<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Checking sales data for WhatsApp functionality...\n\n";

// Check customers with phone numbers
$customersWithPhone = App\Models\Customer::whereNotNull('phone')->get();
echo "Customers with phone numbers:\n";
foreach ($customersWithPhone as $customer) {
    echo "- {$customer->name}: {$customer->phone}\n";
}

echo "\n";

// Check recent sales with customer data
$sales = App\Models\Sale::with('customer')->orderBy('created_at', 'desc')->limit(5)->get();
echo "Recent sales:\n";
foreach ($sales as $sale) {
    $customerInfo = $sale->customer ? "{$sale->customer->name} ({$sale->customer->phone})" : 'No customer';
    echo "- Sale #{$sale->id}: {$customerInfo}, Amount: {$sale->total_amount}\n";
}

echo "\n";

// Check direct sales
$directSales = App\Models\DirectSales::with('Customer')->limit(5)->get();
echo "Direct sales:\n";
foreach ($directSales as $sale) {
    $customerInfo = $sale->Customer ? "{$sale->Customer->name} ({$sale->Customer->phone})" : $sale->direct_customer_name;
    echo "- Direct Sale #{$sale->id}: {$customerInfo}\n";
}

echo "\nDone!\n";